#!/bin/sh
RSYNC_SCHEDULE_LIST=/etc/.rsyncSchedule.list
ROW=0
ZIP=
UPDATE=
DELETE=
SPARSE=
NETWORK_MONOPOLIZE=
WORKNAME=$1

if [ -z "$WORKNAME" ];then
	echo $0 [workname]
	exit 1
fi

OPTIONS=`cat $RSYNC_SCHEDULE_LIST | grep  -A 10 -w "\[$WORKNAME\]" | grep -w ACTION | awk -F'/usr/bin/rsync' '{print $2}' | awk -F'--port' '{print $1}'`

echo $OPTIONS | awk 'BEGIN{i=1}{while(i <= NF){print $i;i++}}' | while read LINE
do
	ROW=`expr $ROW + 1`
	if [ $ROW -eq 1 ];then
		ZIP=`echo $LINE | grep z`
		if [ ! -z "$ZIP" ];then
			echo zip
		fi
		
		UPDATE=`echo $LINE | grep u`
		if [ ! -z "$UPDATE" ];then
			echo update
		fi
	
	else
		SPARSE=`echo $LINE | grep "\-\-sparse"`
		DELETE=`echo $LINE | grep "\-\-delete"`
		if [ ! -z "$SPARSE" ];then
			echo sparse
		fi
	
		if [ ! -z "$DELETE" ];then
			echo delete
		fi
	fi

done

SSH=`cat $RSYNC_SCHEDULE_LIST | grep  -A 10 -w "\[$WORKNAME\]" | grep -w ACTION | grep ssh`
if [ ! -z "$SSH" ];then
	echo SSH
fi

NETWORK_MONOPOLIZE=`cat $RSYNC_SCHEDULE_LIST | grep  -A 8 -w "\[$WORKNAME\]" | grep -w NETWORK_MONOPOLIZE | awk -F'=' '{print $2}'`
if [ "$NETWORK_MONOPOLIZE" == "1" ];then
	echo network_monopolize
fi

exit 0 
