#!/bin/sh
SCHEDULE_LIST=/etc/.rsyncSchedule.list
WORKNAME=$1

if [ $# -eq 0 ];then
	echo "$0 [workname]"
	exit 1
fi

#echo WORKNAME:$WORKNAME
cat $SCHEDULE_LIST | grep -w -A 12 "\[$WORKNAME\]" | while read LINE
do
	#echo -e "$LINE"
	SRC=`echo -e "$LINE" | awk -F'SRC=' '{print $2}'`
	DEST=`echo -e "$LINE" | awk -F'DEST=' '{print $2}'`
	SCHEDULE=`echo -e "$LINE" | awk -F'SCHEDULE=' '{print $2}'`
	USERNAME=`echo -e "$LINE" | awk -F'USERNAME=' '{print $2}'`
	PASSWD=`echo "$LINE" | awk -F'AUTH_PASSWD=' '{print $2}'`	
	IPADDR=`echo "$LINE" | awk -F'IPADDR=' '{print $2}'`		
	PORT=`echo "$LINE" | grep -w "PORT" | awk -F'PORT=' '{print $2}'`		
	SSHPORT=`echo "$LINE" | grep -w "SSHPORT" | awk -F'SSHPORT=' '{print $2}'`		
	TOPTIONS=`echo "$LINE" | grep -w "TOPTIONS" | awk -F'TOPTIONS=' '{print $2}'`		
	BTYPE=`echo "$LINE" | grep -w "BTYPE" | awk -F'BTYPE=' '{print $2}'`		
	
	if [ ! -z "$SCHEDULE" ];then
		echo -e "SCHEDULE:$SCHEDULE"
	elif [ ! -z "$USERNAME" ];then
		echo USERNAME:$USERNAME
	elif [ ! -z "$PASSWD" ];then
		DECONDE_PASSWD=`echo $PASSWD | base64 -d`
		echo PASSWD:$DECONDE_PASSWD
		continue
	elif [ ! -z "$SRC" ];then
		SHORT_DIR=`echo "$SRC" | awk -F'/' '{print $3}'`
		echo SRC:$SHORT_DIR
	elif [ ! -z "$DEST" ];then
		echo DEST:$DEST
	elif [ ! -z "$IPADDR" ];then
		echo IPADDR:$IPADDR
	elif [ ! -z "$PORT" ];then
		echo PORT:$PORT
	elif [ ! -z "$SSHPORT" ];then
		echo SSHPORT:$SSHPORT
	elif [ ! -z "${TOPTIONS}" ];then
                echo "TOPTIONS:${TOPTIONS}"
	elif [ ! -z "${BTYPE}" ];then
                echo "BTYPE:${BTYPE}"
	fi
done
exit 0
