#!/bin/sh
RSYNC_SCHEDULE=/etc/.rsyncSchedule.list

[ ! -f $RSYNC_SCHEDULE ] && exit 1

grep -A 0 "\[" $RSYNC_SCHEDULE | while read LINE
do
	WORKNAME=`echo -e "$LINE" | sed 's/\[\(.*\)\]/\1/'`
	SCHEDULE=`grep -w -A 8 "\[$WORKNAME\]" $RSYNC_SCHEDULE | grep SCHEDULE | awk -F'=' '{print $2}'`
	
	if [ "$SCHEDULE" = "immediately" ]; then
		echo -e "$WORKNAME|immediately"	
	else
		MIN=`echo -e "$SCHEDULE" | awk '{print $1}'`
		HOUR=`echo -e "$SCHEDULE" | awk '{print $2}'`
		DATE=`echo -e "$SCHEDULE" | awk '{print $3}'`
		MON=`echo -e "$SCHEDULE" | awk '{print $4}'`
		WEEK=`echo -e "$SCHEDULE" | awk '{print $5}'`
		#echo $MIN:$HOUR:$DATE:$MON:$WEEK
		#echo -e "$SCHEDULE"

		[ ${#HOUR} -lt 2 ] && HOUR="0${HOUR}"
		[ ${#MIN} -lt 2 ] && MIN="0${MIN}"
		
		if [ "$DATE" = "*" ];then
			if [ "$WEEK" = "*" ];then
				echo -e "$WORKNAME|$HOUR:$MIN - Daily"
			else
				if [ "$WEEK" = 0 ];then
					WEEK=Sunday
				elif [ "$WEEK" = "1" ];then
					WEEK=Monday
				elif [ "$WEEK" = "2" ];then	
					WEEK=Tuesday
				elif [ "$WEEK" = "3" ];then
					WEEK=Wednesday
				elif [ "$WEEK" = "4" ];then
					WEEK=Thursday
				elif [ "$WEEK" = "5" ];then
					WEEK=Friday
				elif [ "$WEEK" = "6" ];then
					WEEK=Satday				
				fi
				echo -e "$WORKNAME|$HOUR:$MIN - Weekly:$WEEK"
			fi
		else
			echo -e "$WORKNAME|$HOUR:$MIN - Monthly:$DATE"
		fi
	fi
done
