#!/bin/bash

if [ ! -z "${PAM_USER}" ]; then
    uid=$(id -u "${PAM_USER}")
    if [ "$uid" = "0" ]; then
        LOG_TIME=$(date +'%Y-%m-%d %H:%M:%S')
        if [ -z "$PAM_RHOST" ]; then
            key=${PAM_TTY#/dev/*}
            key=${key//\//\\/}
            PAM_RHOST=$(who|awk -F'[()]' "/$key/ {print \$2}")
        fi
        /usr/sbin/ter_msg_add -c ssh -l info -s notification -k notice_rootLogin -o "$LOG_TIME" -o "${PAM_RHOST}" >/dev/null &
    fi
fi

exit 0
