#!/bin/sh
LIST_FILE=/etc/.rsyncSchedule.list
PREFER_SETTING_FILE=/etc/.rsyncPreSetting
WORKNAME=$1
CHECKLOG_RETURN_VALUE=0
WORKNAME_PID=/var/run/rsyncd.pid
WORK_LOCK=/var/lock/$WORKNAME.lock
WORK_LOG_BASE=/usr/local/rsyncd

Check_log(){
	#check rsync backup log
	local CONTENT=`cat $WORK_LOG_BASE/.$WORKNAME.log | grep "rsync error:"`
	if [ -z "$CONTENT" ];then
		CHECKLOG_RETURN_VALUE=0
	else
		CHECKLOG_RETURN_VALUE=1
	fi
}

Workname_pid(){
	[ ! -f $WORKNAME_PID ] && touch $WORKNAME_PID
	
	#Update pid
	local RESULT=`grep -w "$WORKNAME" $WORKNAME_PID`
	if [ ! -z "$RESULT" ];then
		sed -i "/^$WORKNAME:/d" $WORKNAME_PID
	fi
	echo "$WORKNAME:$1" >> $WORKNAME_PID
}

service_action(){
	local act=$1
	local smb_pids=`pgrep smbd`
	local nfs_pids=`pgrep rpcbind`
	local afp_pids=`pgrep afpd`
	local ftp_pids=`pgrep smbftpd`
	if [ "$act" = "stop" ]; then
		[ ! -z "$smb_pids" ] && service samba stop > /dev/null
		[ ! -z "$nfs_pids" ] && service nfs stop > /dev/null
		[ ! -z "$afp_pids" ] && service afp stop > /dev/null
		[ ! -z "$ftp_pids" ] && service ftp stop > /dev/null
	elif [ "$act" = "start" ]; then
		[ -z "$smb_pids" ] && service samba start > /dev/null
		[ -z "$nfs_pids" ] && service nfs start > /dev/null
		[ -z "$afp_pids" ] && service afp start > /dev/null
		[ -z "$ftp_pids" ] && service ftp start > /dev/null
	fi
}

Work_cleanup(){
	[ -e "$WORK_LOCK" ] && rm -f "$WORK_LOCK"	
	[ -e "$WORKNAME_PID" ] && sed -i "/^$WORKNAME:/d" $WORKNAME_PID
}

if [ -z "$WORKNAME" ]; then
	echo -e "Usage: $0 [workname] [start|stop|status]\n"
	exit 1
fi

case $2 in
	start)
		if [ ! -f $LIST_FILE ] ;then
			echo "can't found $LIST_FILE"
			exit 2
		fi

        [ ! -d "$WORK_LOG_BASE" ] && mkdir -p "$WORK_LOG_BASE"
		[ -f "$WORK_LOCK" ] && {
			echo "Work has started!"
			exit 2
		} || touch "$WORK_LOCK"
		[ ! -f "$PREFER_SETTING_FILE" ] && echo -e "PAUSE_TIME=600\nRETRY_TIMES=3\nTIME_INTERVAL=5" > $PREFER_SETTING_FILE
		chmod 755 $PREFER_SETTING_FILE
	
		. $PREFER_SETTING_FILE
	
		#'0' or '1',whether pause other network services(samba,ftp).
		NETWORK_MONOPOLIZE=`cat $LIST_FILE | grep -w -A 10 "\[$WORKNAME\]" | grep  NETWORK_MONOPOLIZE | awk -F'=' '{print $2}'`
	
		#Two difference ACTION,then one adding "--timeout" option
		if [ -z "$PAUSE_TIME" ];then
			ACTION=`cat $LIST_FILE | grep -w -A 10 "\[$WORKNAME\]" | grep ACTION | awk -F'ACTION=' '{print $2}'`
		else
			STRING1=`cat $LIST_FILE | grep -w -A 10 "\[$WORKNAME\]" | grep ACTION | awk -F'--log-file' '{print $1}'`
			STRING2=`cat $LIST_FILE | grep -w -A 10 "\[$WORKNAME\]" | grep ACTION | awk -F'--log-file' '{print $2}'`
			ACTION="${STRING1#*=} --timeout=$PAUSE_TIME --log-file$STRING2"
			echo "${ACTION}"
		fi
		# no action...
		if [ -z "$ACTION" ];then
			echo "No workname found."
			Work_cleanup
			exit 1
		fi
	
		AUTH_PASSWD=`cat $LIST_FILE | grep -A 10 -w "\[$WORKNAME\]" | grep AUTH_PASSWD`
        export RSYNC_PASSWORD=`echo ${AUTH_PASSWD#*=} | base64 -d`
		echo RSYNC_PASSWORD:$RSYNC_PASSWORD
		
		#Clean log.
		cat /dev/null > $WORK_LOG_BASE/.$WORKNAME.log
	
		#Stop services before backup.
		if [ $NETWORK_MONOPOLIZE -gt 0 ]; then
			echo "Stopping other network service..."
			service_action stop
		fi
	
		#Start backup.
		echo "Starting backup..."
		eval "${ACTION}" &
		Workname_pid $!
		wait
			
		#################Prefer settings on web page################
		#CHECKLOG_RETURN_VALUE:0 is success and 1 is failed
		############################################################
		Check_log
		echo "CHECKLOG_RETURN_VALUE:$CHECKLOG_RETURN_VALUE"
		#If backup successfully,then enable serivce.
		if [ $CHECKLOG_RETURN_VALUE -eq 0 ];then
			[ $NETWORK_MONOPOLIZE -gt 0 ] && service_action start
			Work_cleanup
			exit 0
		fi
	
		#If backup failed,then retry.
		times=$RETRY_TIMES
		time_interval=$TIME_INTERVAL
		RETRY=0
	
		[ "x$times" = "x" ] && {
			Work_cleanup
			exit 0
		}
		while [ $times -gt 0 ]
		do
			echo -n "Sleeping $time_interval seconds:"
			sleep $time_interval
			echo "waked."
			times=`expr $times - 1`	
			RETRY=`expr $RETRY + 1`
			echo RETRY_TIMES=$RETRY > $WORK_LOG_BASE/.$WORKNAME.log 
		
			echo "Starting backup..."
			eval "${ACTION}" &
			Workname_pid $!
			wait
		
			Check_log
			echo CHECKLOG_RETURN_VALUE:$CHECKLOG_RETURN_VALUE
			[ $CHECKLOG_RETURN_VALUE -eq 0 ] && break
	
			if [ $RETRY -eq $RETRY_TIMES ];then
				sed -i "/^RETRY_TIMES=/c\\RETRY_TIMES=`expr $RETRY_TIMES + 1`" $WORK_LOG_BASE/.$WORKNAME.log
			fi
		done
		
		if [ $NETWORK_MONOPOLIZE -gt 0 ]; then
			echo "Starting other network service..."
			service_action start
			Work_cleanup
		fi
		;;
	stop)
		#Stop script.
		echo "Stopping rsyncBackup.sh $WORKNAME start..."
		#result=`ps aux | grep -v grep | grep "rsyncBackup.sh $WORKNAME start"`
		ps -ef | grep -v grep | grep "rsyncBackup.sh $WORKNAME start" | while read u p o
		do
			kill -9 $p
		done
		
		#Stop rsync backup program
		PID=`cat $WORKNAME_PID | grep -w "$WORKNAME" | awk -F':' '{print $2}'`
		echo "Stopping backup program[$PID]"
		if [ ! -z "$PID" ];then
			#result=`ps aux | grep -v grep | grep -w $PID`
                        #[ ! -z "$result" ] && kill -9 $PID
			result=`ps -ef | grep "/etc/rsyncd/.${WORKNAME}.log" | grep -v grep | awk '{print $2}'`
			[ ! -z "$result" ] && kill -9 $result
		fi
		Work_cleanup

		#Put error message
		echo -e "rsync error:killed" > $WORK_LOG_BASE/.$WORKNAME.log
		;;
	status)
		PID=`cat $WORKNAME_PID | grep -w "$WORKNAME" | awk -F':' '{print $2}'`
		if [ ! -z "$PID" ];then
			result=`ps | grep -v grep | grep -w $PID`
			if [ -z "$result" ];then
				echo "stopped"
			else
				echo "running"
			fi
		else
			echo "stopped"
		fi
		;;
	*)
		echo -e "Usage: $0 [workname] [start|stop|status]\n"
		;;
esac
exit 0
