#!/bin/sh
SnmpsetConfig="/etc/.SNMPset.conf"

if [ $# -ne 2 ];then
	echo "Usage:$0 [type] [message]"
	exit 1
fi

Version=$(grep "version" $SnmpsetConfig | awk -F'=' '{print $2}')
IP=$(grep "addr" $SnmpsetConfig | awk -F'=' '{print $2}')
Events=$(grep "Event" $SnmpsetConfig | awk -F'=' '{print $2}')
Event=$1
Msg=$2

snmptrap()
{
case "$1" in
1|2)
	Community=$(grep "community" $SnmpsetConfig | awk -F'=' '{print $2}')
	echo "$IP" | awk -F',' 'BEGIN{i=1}{while(1){if($i=="")break;print $i;i++}}' | while read ip
	do
		/usr/bin/snmptrap -v 2c -c $Community $ip:162 -i 2 NAS-MIB::$Event s "$Msg"
	done
	;;
3)
	Username=$(grep "user_name" $SnmpsetConfig | awk -F'=' '{print $2}')
	AuthMethod=$(grep "auth_method" $SnmpsetConfig | awk -F'=' '{print $2}')
	AuthPasswd=$(grep "auth_passwd" $SnmpsetConfig | awk -F'=' '{print $2}')
	EntryptPasswd=$(grep "encrypt_passwd" $SnmpsetConfig | awk -F'=' '{print $2}')
	
	if [ $AuthMethod -eq 1 ];then
		AuthMethod="SHA"
	elif [ $AuthMethod -eq 2 ];then
		AuthMethod="MD5"
	else
		AuthMethod=""
	fi

	[ "x$Username" = "x" ] && exit 1
	
	if [ "x$AuthMethod" = "x" ];then
		AuthString="-l noAuthNoPriv -u $Username"
	else
		if [ "x$EncryptPasswd" = "x" ];then
			AuthString="-l authNoPriv -u $Username -a $AuthMethod -A $AuthPasswd"
		else #default:DES encryption
			AuthString="-l authNoPriv -u $Username -a $AuthMethod -A $AuthPasswd -x DES -X $EntryptPasswd"
		fi
	fi
	
	#send trap
	echo "$IP" | awk -F',' 'BEGIN{i=1}{while(1){if($i=="")break;print $i;i++}}' | while read ip
	do
		/usr/bin/snmptrap -v 3 $AuthString $ip:162 -i 2 NAS-MIB::$Event s "$Msg"
	done
	;;
*)
	exit 0
esac
}

#no destination for trap
[ "x$IP" = "x" ] && exit 1

#whether the event is registered
echo "$Events" | awk -F',' 'BEGIN{i=1}{while(1){if($i=="")break;print $i;i++}}' | while read event
do
	if [ "x$event" = "x$Event" ];then
		snmptrap $Version
		break
	else
		continue
	fi
done
exit 0
