#!/bin/bash
PIDFILE="/var/run/ovpn-route-monitor.pid"
restore_routes() {
    for f in /tmp/ovpn_route_info_*; do
        [ -f "$f" ] || continue
        read -r server gw dev < "$f" 2>/dev/null || continue
        [ -n "$server" ] && [ -n "$gw" ] && [ -n "$dev" ] || continue
        ip route show | grep -q "$server via $gw dev $dev" && continue
        ip route show | grep -q "via $gw dev $dev" || continue
        ip route add "$server" via "$gw" dev "$dev" 2>/dev/null
    done
}
start_monitor() {
    [ -f "$PIDFILE" ] && kill -0 "$(cat "$PIDFILE")" 2>/dev/null && exit 0
    
    [ -f "$PIDFILE" ] && kill "$(cat "$PIDFILE")" 2>/dev/null
    pkill -f "ip monitor route" 2>/dev/null
    
    echo $$ > "$PIDFILE"
    ip monitor route | while read -r _; do
        sleep 1
        restore_routes
    done &
}
stop_monitor() {
    [ -f "$PIDFILE" ] && kill "$(cat "$PIDFILE")" 2>/dev/null
    rm -f "$PIDFILE"
    pkill -f "ip monitor route" 2>/dev/null
}
case "$1" in
    start)
        start_monitor "$2"
        ;;
    stop)
        stop_monitor
        ;;
    restart)
        stop_monitor
        sleep 1
        start_monitor
        ;;
    *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
        ;;
esac
