#!/bin/sh
get_openvpn_config_name() {
    local cmd_line="$1"
    local config_path=""
    local config_name=""
    config_path=$(echo "$cmd_line" | grep -oP '\-\-config \K[^ ]+')
    if [[ -n "$config_path" ]]; then
        if [[ "$config_path" =~ /etc/openvpn/importOpen/([^/]+)/ ]]; then
            config_name="${BASH_REMATCH[1]}"
        elif [[ "$config_path" =~ /etc/openvpn/user/client_o(.+) ]]; then
            config_name="${BASH_REMATCH[1]}"
        fi
    fi
    echo "$config_name"
}
get_first_openvpn_config_name() {
    local config_name=""
    local openvpn_procs=$(ps -eo args | grep '[o]penvpn')
    if [[ -z "$openvpn_procs" ]]; then
        return 0 # 返回一个空字符串
    fi
    while IFS= read -r line; do
        config_name=$(get_openvpn_config_name "$line")
        if [[ -n "$config_name" ]]; then
            echo "$config_name"
            return 0
        fi
    done <<< "$openvpn_procs"
    return 0
}
first_config_name=$(get_first_openvpn_config_name)
if [[ -n "$first_config_name" ]]; then
    echo "找到第一个非空的配置名: $first_config_name"
else
    echo "未找到任何匹配的 OpenVPN 配置名。"
fi
get_first_openvpn_config_path() {
    local openvpn_procs=$(ps -eo args | grep '[o]penvpn')
    local config_path=""
    if [[ -z "$openvpn_procs" ]]; then
        return
    fi
    while IFS= read -r line; do
        config_path=$(echo "$line" | grep -oP '\-\-config \K[^ ]+')
        if [[ "$config_path" =~ ^/etc/openvpn/importOpen/([^/]+)/[^/]+$ ]] || [[ "$config_path" =~ ^/etc/openvpn/user/client_o.+ ]]; then
            echo "$config_path"
            return
        fi
    done <<< "$openvpn_procs"
}
get_config_name_from_path() {
    local config_path="$1"
    if [[ "$config_path" =~ /etc/openvpn/importOpen/([^/]+)/ ]]; then
        echo "${BASH_REMATCH[1]}"
    elif [[ "$config_path" =~ /etc/openvpn/user/client_o(.+) ]]; then
        echo "${BASH_REMATCH[1]}"
    fi
}
get_config_dir_from_path() {
    local config_path="$1"
    if [[ "$config_path" =~ /etc/openvpn/importOpen/([^/]+)/ ]]; then
        echo "/etc/openvpn/importOpen"
    elif [[ "$config_path" =~ /etc/openvpn/user/client_o(.+) ]]; then
        echo "/etc/openvpn/user"
    fi
}
config_path=$(get_first_openvpn_config_path)
config_name=$(get_config_name_from_path "$config_path")
route_ip=$5
DEVICE=$1
echo "$config_name:$DEVICE" > /tmp/tun_"$config_name"
vpn_server_ip=$trusted_ip
route_info=$(ip route get 8.8.8.8)
physical_gw_ip=$(echo "$route_info" | awk '/via/ {print $3}')
physical_gw_dev=$(echo "$route_info" | awk '/dev/ {print $5}')
if [ -n "$vpn_server_ip" ] && [ -n "$physical_gw_ip" ] && [ -n "$physical_gw_dev" ] && [ -n "$config_name" ]; then
    echo "$vpn_server_ip $physical_gw_ip $physical_gw_dev" > "/tmp/ovpn_route_info_$config_name"
fi
