#!/bin/bash

DEBUG_LEVEL="7 7 1 7"
DEFAULT_LEVEL="4 4 1 7"
CONFIG_FILE="/etc/sysctl.d/98-printk.conf"

# update conf
update_sysctl() {
    echo "kernel.printk = $1" | tee "$CONFIG_FILE" > /dev/null
    sysctl -p "$CONFIG_FILE" > /dev/null
}

case "$1" in
    start)
        echo "$DEBUG_LEVEL" | tee /proc/sys/kernel/printk > /dev/null
        update_sysctl "$DEBUG_LEVEL"
        ;;
    stop)
        echo "$DEFAULT_LEVEL" | tee /proc/sys/kernel/printk > /dev/null
        update_sysctl "$DEFAULT_LEVEL"
        ;;
    *)
        echo "Usage: $0 {start|stop}"
        exit 1
        ;;
esac
