#!/bin/bash

. /etc/profile
pid_dir=/var/run/nut
upsd_dir=/var/run/upsd
usb_drivers=/etc/nutscan-usb.h

PRODUCT=$1
PRODUCT=$(echo "$PRODUCT" | sed 's/-/\//g')

# don't know what it means
if [ ! -d $pid_dir -o ! -d $upsd_dir ]; then
	mkdir -p $pid_dir $upsd_dir
fi

# check if our supported ups device
vendorID=`echo $PRODUCT | awk -F/ '{printf("0x%04s", $1);}' | sed 's: :0:g'`
productID=`echo $PRODUCT | awk -F/ '{printf("0x%04s", $2);}' | sed 's: :0:g'`

driver=`awk -F "[{|}]" '{if(NF==3)print $2 }' "$usb_drivers" |\
	awk -v vid=$vendorID -v pid=$productID -F ","\
		'{if(match($1,vid)!=0&&match($2,pid)!=0)print$3}'`
#driver=`awk -v vid=$vendorID -v pid=$productID -F [,\ \"]\
#	'NF == 10 && $2 == vid && $4 == pid {print $7}' $usb_drivers`

if [ -n "$driver" ]; then
	if [ ! -f "/tmp/upsevent_add" ]; then
		touch /tmp/upsevent_add
	fi
	if [ -f "/etc/ups_v2.config" ]; then
		en=$(grep -E '"enabled":[[:space:]]*true' /etc/ups_v2.config)
		if [ $? -eq 0 ]; then
			en=$(grep -E '"type":[[:space:]]*1' /etc/ups_v2.config)
			if [ $? -ne 0 ]; then
				echo "do not switch ups connect type"
				exit 0
			fi
		fi
	fi
	/usr/bin/upsctl on_usb_add $driver
else
	echo "unsupported"
fi
exit 0
